"use client";

import { useEffect } from "react";


export default function FaqsSection() {

    useEffect(() => {
        const groups = document.querySelectorAll(".accrodion-grp");

        groups.forEach((group) => {
            const groupName = group.getAttribute("data-grp-name");
            const accordions = group.querySelectorAll(".accrodion");

            if (groupName) {
                group.classList.add(groupName);
            }

            accordions.forEach((accordion) => {
                const content = accordion.querySelector(".accrodion-content") as HTMLElement;

                if (!content) return;

                content.style.overflow = "hidden";
                content.style.transition = "height 0.35s ease";

                if (accordion.classList.contains("active")) {
                    content.style.height = content.scrollHeight + "px";
                } else {
                    content.style.height = "0px";
                }

                const title = accordion.querySelector(".accrodion-title");

                title?.addEventListener("click", function () {

                    if (!accordion.classList.contains("active")) {

                        // Close all
                        document
                            .querySelectorAll(`.accrodion-grp.${groupName} .accrodion`)
                            .forEach((item) => {
                                item.classList.remove("active");

                                const el = item.querySelector(".accrodion-content") as HTMLElement;
                                if (!el) return;

                                el.style.height = el.scrollHeight + "px";
                                requestAnimationFrame(() => {
                                    el.style.height = "0px";
                                });
                            });

                        // Open current
                        accordion.classList.add("active");

                        content.style.height = "0px";
                        requestAnimationFrame(() => {
                            content.style.height = content.scrollHeight + "px";
                        });
                    }
                });
            });
        });
    }, []);

    return (
        <>
            <section className="faq-one">
                <div className="container">
                    <div className="section-title text-center sec-title-animation animation-style1">
                        <div className="section-title__tagline-box">
                            <div className="section-title__tagline-shape"></div>
                            <span className="section-title__tagline">FAQ</span>
                        </div>
                        <h2 className="section-title__title title-animation">Frequency & Questions
                        </h2>
                    </div>
                    <div className="faq-one__inner">
                        <div className="accrodion-grp" data-grp-name="faq-one-accrodion">
                            <div className="accrodion active wow fadeInLeft" data-wow-delay="0ms" data-wow-duration="1500ms">
                                <div className="accrodion-title">
                                    <h4>What services does your digital agency offer?</h4>
                                </div>
                                <div className="accrodion-content">
                                    <div className="inner">
                                        <p>Meeting project deadlines is a top priority. We understand the importance of
                                            timely delivery and have established a comprehensive approach to ensure that all
                                            projects are completed on schedule without compromising quality.
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div className="accrodion wow fadeInRight" data-wow-delay="100ms" data-wow-duration="1500ms">
                                <div className="accrodion-title">
                                    <h4>How long does it take to complete a project?</h4>
                                </div>
                                <div className="accrodion-content">
                                    <div className="inner">
                                        <p>Meeting project deadlines is a top priority. We understand the importance of
                                            timely delivery and have established a comprehensive approach to ensure that all
                                            projects are completed on schedule without compromising quality.
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div className="accrodion wow fadeInRight" data-wow-delay="100ms" data-wow-duration="1500ms">
                                <div className="accrodion-title">
                                    <h4>Do you offer ongoing support and maintenance?</h4>
                                </div>
                                <div className="accrodion-content">
                                    <div className="inner">
                                        <p>Meeting project deadlines is a top priority. We understand the importance of
                                            timely delivery and have established a comprehensive approach to ensure that all
                                            projects are completed on schedule without compromising quality.
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div className="accrodion wow fadeInRight" data-wow-delay="100ms" data-wow-duration="1500ms">
                                <div className="accrodion-title">
                                    <h4>Will my website be mobile-friendly and SEO optimized?</h4>
                                </div>
                                <div className="accrodion-content">
                                    <div className="inner">
                                        <p>Meeting project deadlines is a top priority. We understand the importance of
                                            timely delivery and have established a comprehensive approach to ensure that all
                                            projects are completed on schedule without compromising quality.
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div className="accrodion wow fadeInRight" data-wow-delay="100ms" data-wow-duration="1500ms">
                                <div className="accrodion-title">
                                    <h4>What is your pricing model?</h4>
                                </div>
                                <div className="accrodion-content">
                                    <div className="inner">
                                        <p>Meeting project deadlines is a top priority. We understand the importance of
                                            timely delivery and have established a comprehensive approach to ensure that all
                                            projects are completed on schedule without compromising quality.
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </>
    );
}
