import { useEffect } from "react";
import AOS from "aos";
import "aos/dist/aos.css";
import BannerOneIconImg from '../../public/images/icon/banner-one-icon-man.png'
import BannerOneReview1 from '../../public/images/resources/banner-one-review-img-1-1.jpg'
import BannerOneReview2 from '../../public/images/resources/banner-one-review-img-1-2.jpg'
import BannerOneReview3 from '../../public/images/resources/banner-one-review-img-1-3.jpg'
import BgImg1 from '../../public/images/shapes/banner-one-shape-bg.png'
import BgImg2 from '../../public/images/shapes/banner-one-shape-1.png'

export default function HeroSection() {


     useEffect(() => {
    if (document.querySelector("[data-aos]")) {
      AOS.init({
        duration: 1200,
        easing: "ease",
        mirror: true,
        once: false,
      });

      AOS.refresh();
    }
  }, []);


    return (
        <>
            <section className="banner-one">
                <div className="banner-one__one-shape-bg"
                    style={{ backgroundImage: `url(${BgImg1.src})` }}></div>
                <div className="banner-one__shape-one"
                    style={{ backgroundImage: `url(${BgImg2.src})` }}></div>
                <div className="banner-one__shape-two"></div>
                <div className="container">
                    <div className="banner-one__inner">
                        <div className="banner-one__sub-title-box">
                            <p>Great design services <br /> without the pretentiousness.!</p>
                        </div>
                        <div className="banner-one__content-one" data-aos="fade-right" data-aos-duration="1000"
                            data-aos-delay="0">
                            <h2 className="banner-one__big-title-one">Digital</h2>
                        </div>
                        <div className="banner-one__content-two" data-aos="fade-left" data-aos-duration="1000"
                            data-aos-delay="500">
                            <ul className="banner-one__content-two-list">
                                <li>
                                    <div className="banner-one__content-two-single">
                                        <h3>WEB <br /> DESIGN</h3>
                                    </div>
                                </li>
                                <li>
                                    <div className="banner-one__content-two-single-two">
                                        <img src={BannerOneIconImg.src} alt="" />
                                    </div>
                                </li>
                            </ul>
                            <h2 className="banner-one__big-title-two">Solution</h2>
                        </div>
                        <div className="banner-one__details-box">
                            <div className="banner-one__text-box-one">
                                <p>We believe that the surest measure of success is when our partners with us more than half
                                    It's more than just the visuals. We're here to support your growth.</p>
                                <a href="#">View all Services<span className="icon-arrow-up-right"></span></a>
                            </div>
                            <div className="banner-one__review-box">
                                <ul className="banner-one__review-list">
                                    <li>
                                        <div className="banner-one__review-img">
                                            <img src={BannerOneReview1.src} alt="" />
                                        </div>
                                    </li>
                                    <li>
                                        <div className="banner-one__review-img">
                                            <img src={BannerOneReview2.src} alt="" />
                                        </div>
                                    </li>
                                    <li>
                                        <div className="banner-one__review-img">
                                            <img src={BannerOneReview3.src} alt="" />
                                        </div>
                                    </li>
                                    <li>
                                        <div className="banner-one__review-count-box">
                                            <h3 className="odometer" data-count="15">00</h3>
                                            <span>K+</span>
                                        </div>
                                    </li>
                                </ul>
                                <div className="banner-one__review-text-box">
                                    <div className="banner-one__review-text">
                                        <p>Excellent</p>
                                        <div className="banner-one__review-text-count-box">
                                            <h3 className="odometer" data-count="4000">00</h3>
                                            <span>+</span>
                                        </div>
                                        <p>Reviews</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

        </>
    );
}
