"use client";

import { useEffect, useRef } from "react";
import { gsap } from "@/helpers/gsap";

type LoaderProps = {
  onFinish?: () => void;
};

export default function Loader({ onFinish }: LoaderProps) {
  const loaderRef = useRef<HTMLDivElement | null>(null);

  useEffect(() => {

    if (!loaderRef.current) return;

    const tl = gsap.timeline({
      onComplete: () => {
        onFinish?.(); // agar parent ko notify karna ho
      },
    });

    tl.to(loaderRef.current, {
      delay: 0.5,
      duration: 0.5,
      opacity: 0,
      ease: "power2.out",
    }).set(loaderRef.current, {
      display: "none",
    });

    return () => {
      tl.kill();
    };
  }, []);

  return (

    <div ref={loaderRef} className="loader js-preloader">
        <div></div>
        <div></div>
        <div></div>
    </div>
  );
}
