"use client";

import { Swiper, SwiperSlide } from "swiper/react";
import Image from "react-bootstrap/Image";

export default function PortfolioSlider() {
  return (
    <>
      <Swiper
        slidesPerView={3}
        spaceBetween={0}
        speed={600}
        loop={true}
        autoplay={{
          delay: 8000,
        }}
        grabCursor={true}
        pagination={{
          el: ".swiper-dot-style1",
          type: "bullets",
          clickable: true,
        }}
        navigation={{
          nextEl: ".swiper-button-prev1",
          prevEl: ".swiper-button-next1",
        }}
        // modules={[Pagination]}
        className="portfolio-three__carousel"
        breakpoints={{
          0: {
            spaceBetween: 0,
            slidesPerView: 1,
          },
          375: {
            spaceBetween: 0,
            slidesPerView: 1,
          },
          575: {
            spaceBetween: 10,
            slidesPerView: 1,
          },
          768: {
            spaceBetween: 30,
            slidesPerView: 2,
          },
          992: {
            spaceBetween: 60,
            slidesPerView: 3,
          },
          1200: {
            spaceBetween: 60,
            slidesPerView: 3,
          },
          1320: {
            spaceBetween: 60,
            slidesPerView: 3,
          },
        }}
      >
        <SwiperSlide>
          <div className="portfolio-three__single">
            <div className="portfolio-three__img-box">
              <div className="portfolio-three__img">
                <Image src="/images/project/portfolio1.png" alt="" />
              </div>
              <div className="portfolio-three__content">
                <h3 className="portfolio-three__single-title">
                  <a href="portfolio-details.html">Portfolio Center Slider</a>
                </h3>
                <p className="portfolio-three__sub-title">Branding</p>
              </div>
              <div className="portfolio-three__arrow">
                <a href="/images/project/portfolio1.png" className="img-popup">
                  <span className="icon-arrow-up-right"></span>
                </a>
              </div>
            </div>
          </div>
        </SwiperSlide>
        <SwiperSlide>
          <div className="portfolio-three__single">
            <div className="portfolio-three__img-box">
              <div className="portfolio-three__img">
                <Image src="/images/project/portfolio2.png" alt="" />
              </div>
              <div className="portfolio-three__content">
                <h3 className="portfolio-three__single-title">
                  <a href="portfolio-details.html">Portfolio Center Slider</a>
                </h3>
                <p className="portfolio-three__sub-title">Branding</p>
              </div>
              <div className="portfolio-three__arrow">
                <a href="/images/project/portfolio2.png" className="img-popup">
                  <span className="icon-arrow-up-right"></span>
                </a>
              </div>
            </div>
          </div>
        </SwiperSlide>
        <SwiperSlide>
          <div className="portfolio-three__single">
            <div className="portfolio-three__img-box">
              <div className="portfolio-three__img">
                <Image src="/images/project/portfolio3.png" alt="" />
              </div>
              <div className="portfolio-three__content">
                <h3 className="portfolio-three__single-title">
                  <a href="portfolio-details.html">Portfolio Center Slider</a>
                </h3>
                <p className="portfolio-three__sub-title">Branding</p>
              </div>
              <div className="portfolio-three__arrow">
                <a href="/images/project/portfolio3.png" className="img-popup">
                  <span className="icon-arrow-up-right"></span>
                </a>
              </div>
            </div>
          </div>
        </SwiperSlide>
        <SwiperSlide>
          <div className="portfolio-three__single">
            <div className="portfolio-three__img-box">
              <div className="portfolio-three__img">
                <Image src="/images/project/portfolio1.png" alt="" />
              </div>
              <div className="portfolio-three__content">
                <h3 className="portfolio-three__single-title">
                  <a href="portfolio-details.html">Portfolio Center Slider</a>
                </h3>
                <p className="portfolio-three__sub-title">Branding</p>
              </div>
              <div className="portfolio-three__arrow">
                <a href="/images/project/portfolio1.png" className="img-popup">
                  <span className="icon-arrow-up-right"></span>
                </a>
              </div>
            </div>
          </div>
        </SwiperSlide>
        <SwiperSlide>
          <div className="portfolio-three__single">
            <div className="portfolio-three__img-box">
              <div className="portfolio-three__img">
                <Image src="/images/project/portfolio2.png" alt="" />
              </div>
              <div className="portfolio-three__content">
                <h3 className="portfolio-three__single-title">
                  <a href="portfolio-details.html">Portfolio Center Slider</a>
                </h3>
                <p className="portfolio-three__sub-title">Branding</p>
              </div>
              <div className="portfolio-three__arrow">
                <a href="/images/project/portfolio2.png" className="img-popup">
                  <span className="icon-arrow-up-right"></span>
                </a>
              </div>
            </div>
          </div>
        </SwiperSlide>
        <SwiperSlide>
          <div className="portfolio-three__single">
            <div className="portfolio-three__img-box">
              <div className="portfolio-three__img">
                <Image src="/images/project/portfolio3.png" alt="" />
              </div>
              <div className="portfolio-three__content">
                <h3 className="portfolio-three__single-title">
                  <a href="portfolio-details.html">Portfolio Center Slider</a>
                </h3>
                <p className="portfolio-three__sub-title">Branding</p>
              </div>
              <div className="portfolio-three__arrow">
                <a href="/images/project/portfolio3.png" className="img-popup">
                  <span className="icon-arrow-up-right"></span>
                </a>
              </div>
            </div>
          </div>
        </SwiperSlide>
      </Swiper>
    </>
  );
}
