
import { useEffect, ReactNode } from "react";
import Lenis from 'lenis'
import 'lenis/dist/lenis.css'

interface ScrollProps {
  children: ReactNode;
}

const SmoothScrolling: React.FC<ScrollProps> = ({ children }) => {
  useEffect(() => {
    let lenis: Lenis | null = null;

    function initLenis() {
      if (window.innerWidth > 991 && !lenis) {
        lenis = new Lenis({
          duration: 1.2,
          easing: function (t) {
            return t === 1 ? 1 : 1 - Math.pow(2, -10 * t);
          },
          touchMultiplier: 2,
        });

        function scroll(time: number) {
          if (lenis) {
            lenis.raf(time);
            requestAnimationFrame(scroll);
          }
        }
        requestAnimationFrame(scroll);
      }
    }

    function destroyLenis() {
      if (lenis) {
        lenis.destroy();
        lenis = null;
      }
    }

    function handleResize() {
      if (window.innerWidth <= 991) {
        destroyLenis();
      } else {
        if (!lenis) {
          initLenis();
        }
      }
    }

    initLenis();
    window.addEventListener('resize', handleResize);

    return () => {
      destroyLenis();
      window.removeEventListener('resize', handleResize);
    };
  }, []);

  return <>{children}</>;
};

export default SmoothScrolling;