
import { Swiper, SwiperSlide } from 'swiper/react';
import { Pagination, Autoplay } from 'swiper/modules';

import 'swiper/css';
import 'swiper/css/pagination';
import TestimonialOneShape1 from '../../public/images/shapes/testimonial-one-shape-1.png'
import TestimonialOne from '../../public/images/testimonial/testimonial-1-1.jpg'

export default function TestimonialSection() {


    return (
        <>
            <section className="testimonial-one">
                <div className="testimonial-one__shape-1 float-bob-y">
                    <img src={TestimonialOneShape1.src} alt="" />
                </div>
                <div className="container">
                    <div className="row">
                        <div className="col-xl-7 col-lg-7">
                            <div className="testimonial-one__left">
                                <div className="section-title text-left sec-title-animation animation-style2">
                                    <div className="section-title__tagline-box">
                                        <div className="section-title__tagline-shape"></div>
                                        <span className="section-title__tagline">OUR TESTIMONIALS</span>
                                    </div>
                                    <h2 className="section-title__title title-animation">Hear Real Stories from Happy Clients
                                    </h2>
                                </div>
                                
                                <div className="testimonial-one__carousel">
                                    <Swiper
                                        modules={[Pagination, Autoplay]}
                                        slidesPerView={1}
                                        spaceBetween={0}
                                        speed={2000}
                                        loop={true}
                                        autoplay={{
                                            delay: 8000,
                                            disableOnInteraction: false,
                                        }}
                                        pagination={{
                                            el: '.swiper-dot-style1',
                                            clickable: true,
                                        }}
                                        breakpoints={{
                                            0: { slidesPerView: 1, spaceBetween: 0 },
                                            575: { slidesPerView: 1, spaceBetween: 10 },
                                            768: { slidesPerView: 1, spaceBetween: 30 },
                                            992: { slidesPerView: 1, spaceBetween: 30 },
                                            1200: { slidesPerView: 1, spaceBetween: 30 },
                                            1320: { slidesPerView: 1, spaceBetween: 30 },
                                        }}
                                    >
                                        <SwiperSlide>

                                            <div className="testimonial-one__single">
                                                <div className="testimonial-one__name-and-quote">
                                                    <div className="testimonial-one__name-box">
                                                        <h3 className="testimonial-one__name"><a href="testimonial.html">Ralph
                                                            Edwards</a>
                                                        </h3>
                                                        <p className="testimonial-one__sub-title">CEO,AB Tech</p>
                                                    </div>
                                                    <div className="testimonial-one__quote">
                                                        <span className="icon-quote"></span>
                                                    </div>
                                                </div>
                                                <p className="testimonial-one__text">"We were struggling to rank for relevant
                                                    keywords before partnering with Our Agency . Their team developed a
                                                    comprehensive SEO strategy that the helped us climb the search engine
                                                    rankings and attract our most target audience. We're highly more
                                                    impressed with their results” </p>
                                                <div className="testimonial-one__author-and-ratting">
                                                    <div className="testimonial-one__author">
                                                        <div className="icon">
                                                            <span className="fas fa-star"></span>
                                                        </div>
                                                        <div className="content">
                                                            <span>Verified By</span>
                                                            <h3>TRUSTPIOLT</h3>
                                                        </div>
                                                    </div>
                                                    <div className="testimonial-one__ratting">
                                                        <span className="fas fa-star"></span>
                                                        <span className="fas fa-star"></span>
                                                        <span className="fas fa-star"></span>
                                                        <span className="fas fa-star"></span>
                                                        <span className="fas fa-star-half"></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </SwiperSlide>

                                        <SwiperSlide>

                                            <div className="testimonial-one__single">
                                                <div className="testimonial-one__name-and-quote">
                                                    <div className="testimonial-one__name-box">
                                                        <h3 className="testimonial-one__name"><a href="testimonial.html">Alisha
                                                            Martin</a>
                                                        </h3>
                                                        <p className="testimonial-one__sub-title">CEO,AB Tech</p>
                                                    </div>
                                                    <div className="testimonial-one__quote">
                                                        <span className="icon-quote"></span>
                                                    </div>
                                                </div>
                                                <p className="testimonial-one__text">"We were struggling to rank for relevant
                                                    keywords before partnering with Our Agency . Their team developed a
                                                    comprehensive SEO strategy that the helped us climb the search engine
                                                    rankings and attract our most target audience. We're highly more
                                                    impressed with their results” </p>
                                                <div className="testimonial-one__author-and-ratting">
                                                    <div className="testimonial-one__author">
                                                        <div className="icon">
                                                            <span className="fas fa-star"></span>
                                                        </div>
                                                        <div className="content">
                                                            <span>Verified By</span>
                                                            <h3>TRUSTPIOLT</h3>
                                                        </div>
                                                    </div>
                                                    <div className="testimonial-one__ratting">
                                                        <span className="fas fa-star"></span>
                                                        <span className="fas fa-star"></span>
                                                        <span className="fas fa-star"></span>
                                                        <span className="fas fa-star"></span>
                                                        <span className="fas fa-star-half"></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </SwiperSlide>

                                        <SwiperSlide>

                                            <div className="testimonial-one__single">
                                                <div className="testimonial-one__name-and-quote">
                                                    <div className="testimonial-one__name-box">
                                                        <h3 className="testimonial-one__name"><a href="testimonial.html">David
                                                            Koper</a>
                                                        </h3>
                                                        <p className="testimonial-one__sub-title">CEO,AB Tech</p>
                                                    </div>
                                                    <div className="testimonial-one__quote">
                                                        <span className="icon-quote"></span>
                                                    </div>
                                                </div>
                                                <p className="testimonial-one__text">"We were struggling to rank for relevant
                                                    keywords before partnering with Our Agency . Their team developed a
                                                    comprehensive SEO strategy that the helped us climb the search engine
                                                    rankings and attract our most target audience. We're highly more
                                                    impressed with their results” </p>
                                                <div className="testimonial-one__author-and-ratting">
                                                    <div className="testimonial-one__author">
                                                        <div className="icon">
                                                            <span className="fas fa-star"></span>
                                                        </div>
                                                        <div className="content">
                                                            <span>Verified By</span>
                                                            <h3>TRUSTPIOLT</h3>
                                                        </div>
                                                    </div>
                                                    <div className="testimonial-one__ratting">
                                                        <span className="fas fa-star"></span>
                                                        <span className="fas fa-star"></span>
                                                        <span className="fas fa-star"></span>
                                                        <span className="fas fa-star"></span>
                                                        <span className="fas fa-star-half"></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </SwiperSlide>
                                    </Swiper>

                                    <div className="swiper-nav-style-one">
                                        <div className="swiper-dot-style1"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div className="col-xl-5 col-lg-5">
                            <div className="testimonial-one__right">
                                <div className="testimonial-one__img">
                                    <img src={TestimonialOne.src} alt="" />
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </>
    );
}
