import Head from "next/head";
import React, { useEffect, useRef, useState } from "react";

import AboutFourTRShape from '../../public/images/shapes/about-four-top-right-shape-1.png'
import AboutFourImg1 from '../../public/images/resources/about-four-img-1.jpg'
import AboutFourBTImg from '../../public/images/resources/about-four-bottom-img.jpg'

import PageHeaderBg from '../../public/images/backgrounds/page-header-bg.jpg'
import TeamOne from '../../public/images/team/team-2-1.jpg'
import TeamTwo from '../../public/images/team/team-2-2.jpg'
import TeamThree from '../../public/images/team/team-2-3.jpg'
import AboutSlider from "@/components/AboutSlider";

import TestimonialSection from "../../components/TestimonialSection"
import FaqsSection from "../../components/FaqsSection"



export default function About() {
  // const main = useRef<HTMLElement>(null);

  return (
    <>
      <Head>
        <title>About | Nexin</title>
        <meta name="description" content="" />
      </Head>

      <section className="page-header">
        <div className="page-header__bg" style={{ backgroundImage: `url(${PageHeaderBg.src})` }}>
        </div>
        <div className="container">
          <div className="page-header__inner">
            <h3>About Us</h3>
            <div className="thm-breadcrumb__inner">
              <ul className="thm-breadcrumb list-unstyled">
                <li><a href="index.html">Home</a></li>
                <li>/</li>
                <li>About Us</li>
              </ul>
            </div>
          </div>
        </div>
      </section>

      <section className="about-four">
        <div className="container">
          <div className="about-four__top">
            <div className="row">
              <div className="col-xl-6 col-lg-7">
                <div className="about-four__top-left">
                  <h3 className="about-four__top-title">We have the experience to help you grow</h3>
                </div>
              </div>
              <div className="col-xl-6 col-lg-5">
                <div className="about-four__top-right">
                  <div className="about-four__top-right-shape-1">
                    <img src={AboutFourTRShape.src} alt="" />
                  </div>
                  <p className="about-four__top-text">Vestibulum pulvinar ante auctor, vulputate dui sed<br />
                    condimentum ex nullam pharetra suscipit entum<br /> integer vitae sapien vel est
                    commodo
                  </p>
                </div>
              </div>
            </div>
          </div>
          <div className="about-four__img-1">
            <img src={AboutFourImg1.src} alt="" />
          </div>
          <div className="about-four__content">
            <h2 className="about-four__title-1">Your brand is the most important asset in your<br /> company let our
              team
              of
              professionals help<br /> you with a good strategy</h2>
            <div className="row">
              <div className="col-xl-3 col-lg-4">
                <div className="about-four__experience-box">
                  <div className="about-four__experience-count">
                    <h3 className="odometer" data-count="25">00</h3>
                    <span>+</span>
                  </div>
                  <p className="about-four__experience-count-text">Years Of Experience</p>
                </div>
              </div>
              <div className="col-xl-9 col-lg-8">
                <div className="about-four__single-list">
                  <div className="row">

                    <div className="col-xl-6">
                      <div className="about-four__single">
                        <p className="about-four__text">Established in 1995, NEXIN has been a leading
                          force<br />
                          in
                          the digital landscape for over two decades.<br /> We're a passionate team
                          of
                          designers, </p>
                        <div className="about-four__btn">
                          <a href="about.html">More About Us<span
                            className="icon-arrow-up-right"></span></a>
                        </div>
                      </div>
                    </div>

                    <div className="col-xl-6">
                      <div className="about-four__single about-four__single-2">
                        <p className="about-four__text">Established in 1995, NEXIN has been a leading
                          force<br />
                          in
                          the digital landscape for over two decades.<br /> We're a passionate team
                          of
                          designers, </p>
                        <div className="about-four__btn">
                          <a href="about.html">Get In Touch<span
                            className="icon-arrow-up-right"></span></a>
                        </div>
                      </div>
                    </div>

                  </div>
                </div>
              </div>
            </div>
          </div>
          <div className="about-four__bottom">
            <div className="row">
              <div className="col-xl-6 col-lg-6">
                <div className="about-four__bottom-left">
                  <div className="about-four__bottom-img">
                    <img src={AboutFourBTImg.src} alt="" />
                  </div>
                </div>
              </div>
              <div className="col-xl-6 col-lg-6">
                <div className="about-four__bottom-right">
                  <ul className="about-four__count-list list-unstyled">
                    <li>
                      <div className="about-four__count-and-text-single">
                        <div className="about-four__count-box">
                          <div className="about-four__count">
                            <h3 className="odometer" data-count="100">00</h3>
                            <span>+</span>
                          </div>
                          <p className="about-four__count-text">Success projects</p>
                        </div>
                        <p className="about-four__count-list-text">Vestibulum pulvinar ante auctor,
                          vulputate<br /> dui sed condimentum ex nullam pharetra<br /> suscipit entum
                          integer vitae sapien vel </p>
                      </div>
                    </li>
                    <li>
                      <div className="about-four__count-and-text-single">
                        <div className="about-four__count-box">
                          <div className="about-four__count">
                            <span>$</span>
                            <h3 className="odometer" data-count="25">00</h3>
                            <span>M</span>
                          </div>
                          <p className="about-four__count-text">Revenue generated</p>
                        </div>
                        <p className="about-four__count-list-text">Vestibulum pulvinar ante auctor,
                          vulputate<br /> dui sed condimentum ex nullam pharetra<br /> suscipit entum
                          integer vitae sapien vel </p>
                      </div>
                    </li>
                  </ul>
                  <p className="about-four__bottom-text-1">Currently work at google digital experiences and
                    print
                    materials that communicate clearly. My job is to build your website so that way of
                    giving approaches.</p>
                  <p className="about-four__bottom-text-2">Currently work at google digital experiences and
                    print
                    materials that communicate clearly. My job is to build your website so that it is
                    functional and user friendly but at the same times attractive way of giving
                    approaches.
                  </p>
                </div>
              </div>
            </div>
          </div>
          <div className="about-four__brand">
            <AboutSlider />
          </div>
        </div>
      </section>


      <section className="team-two team-three">
        <div className="container">
          <div className="section-title-three text-center  sec-title-animation animation-style1">
            <div className="section-title-three__tagline-box">
              <span className="section-title-three__tagline">OUR TEAM</span>
            </div>
            <h2 className="section-title-three__title title-animation">Meet The Team</h2>
          </div>
          <div className="row">

            <div className="col-xl-4 col-lg-4 wow fadeInLeft" data-wow-delay="100ms">
              <div className="team-two__single">
                <div className="team-two__img-box">
                  <div className="team-two__img">
                    <img src={TeamOne.src} alt="" />
                  </div>
                </div>
                <div className="team-two__content">
                  <h3 className="team-two__title"><a href="team-details.html">Helman Calderon</a></h3>
                  <p className="team-two__sub-title">Web Developer</p>
                  <div className="team-two__social">
                    <a href="#"><span className="icon-facebook"></span></a>
                    <a href="#"><span className="icon-twitter"></span></a>
                    <a href="#"><span className="icon-instagram"></span></a>
                    <a href="#"><span className="icon-linkin"></span></a>
                  </div>
                </div>
              </div>
            </div>

            <div className="col-xl-4 col-lg-4 wow fadeInUp" data-wow-delay="200ms">
              <div className="team-two__single">
                <div className="team-two__img-box">
                  <div className="team-two__img">
                    <img src={TeamTwo.src} alt="" />
                  </div>
                </div>
                <div className="team-two__content">
                  <h3 className="team-two__title"><a href="team-details.html">Eleanor Pena</a></h3>
                  <p className="team-two__sub-title">UI/UX Designer</p>
                  <div className="team-two__social">
                    <a href="#"><span className="icon-facebook"></span></a>
                    <a href="#"><span className="icon-twitter"></span></a>
                    <a href="#"><span className="icon-instagram"></span></a>
                    <a href="#"><span className="icon-linkin"></span></a>
                  </div>
                </div>
              </div>
            </div>

            <div className="col-xl-4 col-lg-4 wow fadeInRight" data-wow-delay="300ms">
              <div className="team-two__single">
                <div className="team-two__img-box">
                  <div className="team-two__img">
                    <img src={TeamThree.src} alt="" />
                  </div>
                </div>
                <div className="team-two__content">
                  <h3 className="team-two__title"><a href="team-details.html">Devon Lane</a></h3>
                  <p className="team-two__sub-title">Product Designer </p>
                  <div className="team-two__social">
                    <a href="#"><span className="icon-facebook"></span></a>
                    <a href="#"><span className="icon-twitter"></span></a>
                    <a href="#"><span className="icon-instagram"></span></a>
                    <a href="#"><span className="icon-linkin"></span></a>
                  </div>
                </div>
              </div>
            </div>

          </div>
        </div>
      </section>

      <TestimonialSection />
      <FaqsSection />

    </>
  );
}
